unit IWCompRadioButtonWAP;

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing,
  {$ENDIF}
  Classes, IWControlWAP, IWBaseWAPInterfaces, IWBaseControl, IWBaseRenderContext, IWWapTag,
  IWBaseComponent, IWBaseInterfaces, IWMarkupLanguageTag, IWTypes, IWBaseWapControl,
  IWWAPRenderContext;

type
  TIWCustomRadioButtonWAP = class(TIWCustomControlWAP, IIWInputControl)
  protected
    FChecked: Boolean;

    procedure SetValue(const AValue: string); virtual;
    procedure SetChecked(const AValue: Boolean);
    procedure InitControl; override;
  public
    function RenderWap(AContext: TIWBaseWapComponentContext): TIWWapTag; override;

    property Checked: Boolean read FChecked write SetChecked;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWRadioButtonWAP.bmp}
  TIWRadioButtonWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWRadioButtonWAP), 'TIWRadioButtonWAP.bmp')]
  {$ENDIF}
  TIWRadioButtonWAP = class(TIWCustomRadioButtonWAP)
  published
    property Caption;
    {$IFDEF VSNET}
    [Bindable(true)]
    {$ENDIF}    
    property Checked;
  end;

implementation

uses
  SWSYstem, SysUtils;
  
{ TIWCustomRadioButtonWAP }

procedure TIWCustomRadioButtonWAP.InitControl;
begin
  inherited;
  Height := 21;
  Width := 121;
end;

function TIWCustomRadioButtonWAP.RenderWap(
  AContext: TIWBaseWapComponentContext): TIWWapTag;
begin
  if AContext.PageContext.OutputTagType = wotXHTMLMP then begin
    Result := TIWWAPTag.CreateTag('input');
    try
      Result.AddStringParam('type', 'radio');
      Result.AddStringParam('title', TextToXHTMLMP(Caption));
      Result.AddStringParam('name', Name);
      Result.Add(iif(FChecked, 'checked="checked"'));
    except
      FreeAndNil(Result);
      raise;
    end;
  end else begin
    Result := inherited RenderWaP(AContext);
  end
end;

procedure TIWCustomRadioButtonWAP.SetChecked(const AValue: Boolean);
begin
  FChecked := AValue;
  Invalidate;
end;

procedure TIWCustomRadioButtonWAP.SetValue(const AValue: string);
begin
  if RequiresUpdateNotification(Parent) then begin
    UpdateNotifiedInterface(Parent).NotifyUpdate(Self,AValue);
  end;
  FChecked := AnsiSameText(AValue, 'checked');
  Invalidate;
end;

end.
